/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "prg" locale.
 */
public class LocalizedNamesImpl_prg extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AE",
        "AF",
        "AI",
        "AL",
        "AM",
        "AD",
        "AG",
        "AO",
        "AQ",
        "AR",
        "AS",
        "AU",
        "AT",
        "AW",
        "AX",
        "AZ",
        "BS",
        "BB",
        "BD",
        "BE",
        "BZ",
        "BF",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BA",
        "BQ",
        "BR",
        "BT",
        "BG",
        "BV",
        "BW",
        "CC",
        "CD",
        "CZ",
        "CF",
        "CG",
        "CI",
        "CL",
        "CK",
        "CM",
        "CR",
        "CP",
        "CV",
        "CW",
        "CX",
        "CY",
        "DK",
        "GB",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DZ",
        "EA",
        "EG",
        "EH",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FO",
        "FJ",
        "FK",
        "FM",
        "GA",
        "GE",
        "GG",
        "GH",
        "GI",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GD",
        "GL",
        "GS",
        "GU",
        "GY",
        "GW",
        "GT",
        "HT",
        "HK",
        "HM",
        "HN",
        "IC",
        "IE",
        "IL",
        "IM",
        "IN",
        "ID",
        "IO",
        "IQ",
        "IR",
        "IS",
        "JM",
        "JP",
        "JE",
        "JO",
        "CA",
        "KE",
        "KG",
        "KH",
        "KI",
        "CN",
        "KM",
        "KN",
        "CO",
        "XK",
        "KP",
        "BY",
        "HR",
        "CU",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LT",
        "LV",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LU",
        "LY",
        "MA",
        "MK",
        "MT",
        "MX",
        "MF",
        "MG",
        "MH",
        "DE",
        "ML",
        "MM",
        "MN",
        "MO",
        "MD",
        "MC",
        "ME",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MU",
        "MV",
        "MW",
        "MY",
        "MZ",
        "NA",
        "NZ",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "OM",
        "PW",
        "PA",
        "PY",
        "US",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PM",
        "PN",
        "PL",
        "PT",
        "PR",
        "GF",
        "FR",
        "PS",
        "ZA",
        "KR",
        "QA",
        "QO",
        "RE",
        "RO",
        "RU",
        "RW",
        "SM",
        "SA",
        "SB",
        "SC",
        "SD",
        "RS",
        "SG",
        "SH",
        "SJ",
        "SL",
        "SK",
        "SI",
        "SN",
        "SO",
        "FI",
        "ES",
        "SS",
        "ST",
        "SR",
        "SE",
        "CH",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TH",
        "TW",
        "TC",
        "TD",
        "TF",
        "TG",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TT",
        "TR",
        "TV",
        "TZ",
        "UG",
        "UA",
        "UM",
        "UN",
        "HU",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "IT",
        "WF",
        "WS",
        "XA",
        "XB",
        "YE",
        "YT",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "swītai");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Zēimanamērika");
    namesMap.put("005", "Pussideinanamērika");
    namesMap.put("019", "Amērika");
    namesMap.put("142", "Āzija");
    namesMap.put("150", "Eurōpa");
    namesMap.put("AD", "Andōra");
    namesMap.put("AG", "Antīgwa be Barbūda");
    namesMap.put("AL", "Albānija");
    namesMap.put("AR", "Argentīnija");
    namesMap.put("AT", "Āustrarīki");
    namesMap.put("AU", "Austrālija");
    namesMap.put("BA", "Bōsnija be Ercegōwina");
    namesMap.put("BB", "Barbādas");
    namesMap.put("BE", "Belgija");
    namesMap.put("BG", "Bulgārija");
    namesMap.put("BO", "Bōliwija");
    namesMap.put("BR", "Brazīlija");
    namesMap.put("BS", "Bahāmai");
    namesMap.put("BY", "Krēiwa");
    namesMap.put("BZ", "Belīzi");
    namesMap.put("CA", "Kānada");
    namesMap.put("CH", "Šwēici");
    namesMap.put("CL", "Čīli");
    namesMap.put("CN", "Kīna");
    namesMap.put("CO", "Kōlumbija");
    namesMap.put("CU", "Kūba");
    namesMap.put("CZ", "Čekkija");
    namesMap.put("DE", "Mikskātauta");
    namesMap.put("DK", "Dānanmarki");
    namesMap.put("DM", "Dōminika");
    namesMap.put("DO", "Dōminikas Republīki");
    namesMap.put("EC", "Ekwadōrs");
    namesMap.put("EE", "Estantauta");
    namesMap.put("ES", "Špānija");
    namesMap.put("FI", "Sōmija");
    namesMap.put("FO", "Farēirai");
    namesMap.put("FR", "Prankrīki");
    namesMap.put("GB", "Debabritānija");
    namesMap.put("GD", "Grenāda");
    namesMap.put("GF", "Prancōziska Gujāna");
    namesMap.put("GI", "Gibrāltars");
    namesMap.put("GL", "Grēnlandan");
    namesMap.put("GR", "Grēkantauta");
    namesMap.put("GT", "Gwatemāla");
    namesMap.put("GY", "Gujāna");
    namesMap.put("HN", "Hōnduras");
    namesMap.put("HR", "Kruātija");
    namesMap.put("HT", "Haīti");
    namesMap.put("HU", "Ungrai");
    namesMap.put("ID", "Indōnezija");
    namesMap.put("IN", "Īndija");
    namesMap.put("IS", "Īslandan");
    namesMap.put("IT", "Wālkija");
    namesMap.put("JM", "Jamāika");
    namesMap.put("JP", "Japānija");
    namesMap.put("KR", "Pussideinankōreja");
    namesMap.put("LI", "Līchtenšteinan");
    namesMap.put("LT", "Laītawa");
    namesMap.put("LU", "Luksemburgan");
    namesMap.put("LV", "Lattawa");
    namesMap.put("MC", "Mōnakō");
    namesMap.put("MD", "Mōldawija");
    namesMap.put("ME", "Mōntenegran");
    namesMap.put("MK", "Macedōnija");
    namesMap.put("MT", "Mālta");
    namesMap.put("MX", "Meksiku");
    namesMap.put("NI", "Nikarāgwa");
    namesMap.put("NO", "Nōrwigai");
    namesMap.put("NZ", "Nawazēlandan");
    namesMap.put("PA", "Panāma");
    namesMap.put("PE", "Perū");
    namesMap.put("PL", "Pōli");
    namesMap.put("PT", "Pōrtugalin");
    namesMap.put("PY", "Paragwājs");
    namesMap.put("RO", "Rumānija");
    namesMap.put("RS", "Serbija");
    namesMap.put("RU", "Russi");
    namesMap.put("SA", "Saūdi Arābija");
    namesMap.put("SE", "Šwēdija");
    namesMap.put("SI", "Slōwenija");
    namesMap.put("SK", "Slōwakei");
    namesMap.put("SM", "San Marinō");
    namesMap.put("SR", "Surināms");
    namesMap.put("SV", "El Salvadōrs");
    namesMap.put("TH", "Tāilandan");
    namesMap.put("TR", "Turkāja");
    namesMap.put("TT", "Trinidāds be Tobagō");
    namesMap.put("TW", "Taiwāns");
    namesMap.put("UA", "Ukrāini");
    namesMap.put("US", "Peraīnintas Wālstis");
    namesMap.put("UY", "Urugwājs");
    namesMap.put("VE", "Venezuēla");
    namesMap.put("XK", "Kōsawa");
    namesMap.put("ZA", "Pussideinanafrika");
    namesMap.put("ZZ", "niwaistā regiōni");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "swītai",
        "002": "Afrika",
        "003": "Zēimanamērika",
        "005": "Pussideinanamērika",
        "019": "Amērika",
        "142": "Āzija",
        "150": "Eurōpa",
        "AD": "Andōra",
        "AG": "Antīgwa be Barbūda",
        "AL": "Albānija",
        "AR": "Argentīnija",
        "AT": "Āustrarīki",
        "AU": "Austrālija",
        "BA": "Bōsnija be Ercegōwina",
        "BB": "Barbādas",
        "BE": "Belgija",
        "BG": "Bulgārija",
        "BO": "Bōliwija",
        "BR": "Brazīlija",
        "BS": "Bahāmai",
        "BY": "Krēiwa",
        "BZ": "Belīzi",
        "CA": "Kānada",
        "CH": "Šwēici",
        "CL": "Čīli",
        "CN": "Kīna",
        "CO": "Kōlumbija",
        "CU": "Kūba",
        "CZ": "Čekkija",
        "DE": "Mikskātauta",
        "DK": "Dānanmarki",
        "DM": "Dōminika",
        "DO": "Dōminikas Republīki",
        "EC": "Ekwadōrs",
        "EE": "Estantauta",
        "ES": "Špānija",
        "FI": "Sōmija",
        "FO": "Farēirai",
        "FR": "Prankrīki",
        "GB": "Debabritānija",
        "GD": "Grenāda",
        "GF": "Prancōziska Gujāna",
        "GI": "Gibrāltars",
        "GL": "Grēnlandan",
        "GR": "Grēkantauta",
        "GT": "Gwatemāla",
        "GY": "Gujāna",
        "HN": "Hōnduras",
        "HR": "Kruātija",
        "HT": "Haīti",
        "HU": "Ungrai",
        "ID": "Indōnezija",
        "IN": "Īndija",
        "IS": "Īslandan",
        "IT": "Wālkija",
        "JM": "Jamāika",
        "JP": "Japānija",
        "KR": "Pussideinankōreja",
        "LI": "Līchtenšteinan",
        "LT": "Laītawa",
        "LU": "Luksemburgan",
        "LV": "Lattawa",
        "MC": "Mōnakō",
        "MD": "Mōldawija",
        "ME": "Mōntenegran",
        "MK": "Macedōnija",
        "MT": "Mālta",
        "MX": "Meksiku",
        "NI": "Nikarāgwa",
        "NO": "Nōrwigai",
        "NZ": "Nawazēlandan",
        "PA": "Panāma",
        "PE": "Perū",
        "PL": "Pōli",
        "PT": "Pōrtugalin",
        "PY": "Paragwājs",
        "RO": "Rumānija",
        "RS": "Serbija",
        "RU": "Russi",
        "SA": "Saūdi Arābija",
        "SE": "Šwēdija",
        "SI": "Slōwenija",
        "SK": "Slōwakei",
        "SM": "San Marinō",
        "SR": "Surināms",
        "SV": "El Salvadōrs",
        "TH": "Tāilandan",
        "TR": "Turkāja",
        "TT": "Trinidāds be Tobagō",
        "TW": "Taiwāns",
        "UA": "Ukrāini",
        "US": "Peraīnintas Wālstis",
        "UY": "Urugwājs",
        "VE": "Venezuēla",
        "XK": "Kōsawa",
        "ZA": "Pussideinanafrika",
        "ZZ": "niwaistā regiōni"
    };
  }-*/;
}
