/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "az_Cyrl" locale.
 */
public class LocalizedNamesImpl_az_Cyrl extends LocalizedNamesImpl_az {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "EH",
        "EZ",
        "CI",
        "MK",
        "PS",
        "UN",
        "XA",
        "XB",
        "JM",
        "JP",
        "NZ",
        "NC",
        "GR",
        "YE",
        "VI",
        "UM",
        "EU",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DE",
        "US",
        "AS",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AI",
        "AW",
        "AR",
        "AC",
        "BD",
        "BB",
        "BS",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "GB",
        "AE",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "BH",
        "VU",
        "VA",
        "VE",
        "VN",
        "GA",
        "KZ",
        "GM",
        "GH",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "GD",
        "GL",
        "GU",
        "KG",
        "QA",
        "DK",
        "DG",
        "DM",
        "DO",
        "EC",
        "GQ",
        "ER",
        "AM",
        "EE",
        "ET",
        "ZM",
        "ZW",
        "ID",
        "JO",
        "IQ",
        "IR",
        "IE",
        "SE",
        "CH",
        "IS",
        "ES",
        "IL",
        "IT",
        "CV",
        "KH",
        "CM",
        "CA",
        "IC",
        "KY",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CU",
        "CK",
        "CW",
        "KW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "MO",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MH",
        "YT",
        "HU",
        "MX",
        "IM",
        "FM",
        "CX",
        "EG",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MM",
        "SH",
        "PM",
        "MA",
        "CF",
        "NA",
        "NR",
        "NP",
        "NL",
        "NI",
        "NU",
        "NE",
        "NG",
        "NO",
        "NF",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "SM",
        "ST",
        "SZ",
        "SJ",
        "SN",
        "BL",
        "VC",
        "KN",
        "LC",
        "MF",
        "RS",
        "EA",
        "SC",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "SY",
        "SL",
        "SA",
        "TH",
        "TZ",
        "TW",
        "TJ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TR",
        "TM",
        "TC",
        "UG",
        "QO",
        "UA",
        "WF",
        "UY",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HR",
        "TD",
        "CZ",
        "CL",
        "CN",
        "KP",
        "MP",
        "LK",
        "TL",
        "GG",
        "GE",
        "JE",
        "DJ",
        "GI",
        "ZA",
        "KR",
        "SS",
        "GS",
        "HT",
        "HM",
        "IN",
        "HN",
        "HK",
        "DZ",
        "AF",
        "UZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Дүнја");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Шимали Америка");
    namesMap.put("005", "Ҹәнуби Америка");
    namesMap.put("009", "Океанија");
    namesMap.put("011", "Гәрби Африка");
    namesMap.put("013", "Мәркәзи Америка");
    namesMap.put("014", "Шәрги Африка");
    namesMap.put("015", "Шимали Африка");
    namesMap.put("017", "Мәркәзи Африка");
    namesMap.put("018", "Ҹәнуби Африка");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Шимал Америкасы");
    namesMap.put("029", "Кариб");
    namesMap.put("030", "Шәрги Асија");
    namesMap.put("034", "Ҹәнуби Асија");
    namesMap.put("035", "Ҹәнуб-Шәрги Асија");
    namesMap.put("039", "Ҹәнуби Авропа");
    namesMap.put("053", "Австралазија");
    namesMap.put("054", "Меланезија");
    namesMap.put("057", "Микронезија Реҝиону");
    namesMap.put("061", "Полинезија");
    namesMap.put("142", "Асија");
    namesMap.put("143", "Мәркәзи Асија");
    namesMap.put("145", "Гәрби Асија");
    namesMap.put("150", "Авропа");
    namesMap.put("151", "Шәрги Авропа");
    namesMap.put("154", "Шимали Авропа");
    namesMap.put("155", "Гәрби Авропа");
    namesMap.put("419", "Латын Америкасы");
    namesMap.put("AC", "Аскенсон адасы");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Бирләшмиш Әрәб Әмирликләри");
    namesMap.put("AF", "Әфганыстан");
    namesMap.put("AG", "Антигуа вә Барбуда");
    namesMap.put("AI", "Анҝилја");
    namesMap.put("AL", "Албанија");
    namesMap.put("AM", "Ермәнистан");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Арҝентина");
    namesMap.put("AS", "Америка Самоасы");
    namesMap.put("AT", "Австрија");
    namesMap.put("AU", "Австралија");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аланд адалары");
    namesMap.put("AZ", "Азәрбајҹан");
    namesMap.put("BA", "Боснија вә Һерсеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белчика");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "Болгарыстан");
    namesMap.put("BH", "Бәһрејн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сент-Бартелеми");
    namesMap.put("BM", "Бермуд адалары");
    namesMap.put("BN", "Брунеј");
    namesMap.put("BO", "Боливија");
    namesMap.put("BR", "Бразилија");
    namesMap.put("BS", "Баһам адалары");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буве адасы");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларус");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос (Килинг) адалары");
    namesMap.put("CD", "Конго-Киншаса");
    namesMap.put("CF", "Мәркәзи Африка Республикасы");
    namesMap.put("CG", "Конго-Браззавил");
    namesMap.put("CH", "Исвечрә");
    namesMap.put("CI", "Kотд’ивуар");
    namesMap.put("CK", "Кук адалары");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Чин");
    namesMap.put("CO", "Колумбија");
    namesMap.put("CP", "Клиппертон адасы");
    namesMap.put("CR", "Коста Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Курасао");
    namesMap.put("CX", "Милад адасы");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехија");
    namesMap.put("DE", "Алманија");
    namesMap.put("DG", "Диего Гарсија");
    namesMap.put("DJ", "Ҹибути");
    namesMap.put("DK", "Данимарка");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминикан Республикасы");
    namesMap.put("DZ", "Әлҹәзаир");
    namesMap.put("EA", "Сеута вә Мелилја");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естонија");
    namesMap.put("EG", "Мисир");
    namesMap.put("ER", "Еритреја");
    namesMap.put("ES", "Испанија");
    namesMap.put("ET", "Ефиопија");
    namesMap.put("EU", "Авропа Бирлији");
    namesMap.put("FI", "Финландија");
    namesMap.put("FJ", "Фиҹи");
    namesMap.put("FK", "Фолкленд адалары");
    namesMap.put("FM", "Микронезија");
    namesMap.put("FO", "Фарер адалары");
    namesMap.put("FR", "Франса");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Бирләшмиш Краллыг");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Ҝүрҹүстан");
    namesMap.put("GF", "Франса Гвианасы");
    namesMap.put("GG", "Ҝернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Ҹәбәллүтариг");
    namesMap.put("GL", "Гренландија");
    namesMap.put("GM", "Гамбија");
    namesMap.put("GN", "Гвинеја");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Екваториал Гвинеја");
    namesMap.put("GR", "Јунаныстан");
    namesMap.put("GS", "Ҹәнуби Ҹорҹија вә Ҹәнуби Сендвич адалары");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинеја-Бисау");
    namesMap.put("GY", "Гајана");
    namesMap.put("HK", "Һонк Конг Хүсуси Инзибати Әрази Чин");
    namesMap.put("HM", "Һерд вә Макдоналд адалары");
    namesMap.put("HN", "Һондурас");
    namesMap.put("HR", "Хорватија");
    namesMap.put("HT", "Һаити");
    namesMap.put("HU", "Маҹарыстан");
    namesMap.put("IC", "Канар адалары");
    namesMap.put("ID", "Индонезија");
    namesMap.put("IE", "Ирландија");
    namesMap.put("IL", "Исраил");
    namesMap.put("IM", "Мен адасы");
    namesMap.put("IN", "Һиндистан");
    namesMap.put("IO", "Британтјанын Һинд Океаны Әразиси");
    namesMap.put("IQ", "Ираг");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландија");
    namesMap.put("IT", "Италија");
    namesMap.put("JE", "Ҹерси");
    namesMap.put("JM", "Јамајка");
    namesMap.put("JO", "Иорданија");
    namesMap.put("JP", "Јапонија");
    namesMap.put("KE", "Кенија");
    namesMap.put("KG", "Гырғызыстан");
    namesMap.put("KH", "Камбоҹа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Комор адалары");
    namesMap.put("KN", "Сент-Китс вә Невис");
    namesMap.put("KP", "Шимали Кореја");
    namesMap.put("KR", "Ҹәнуби Кореја");
    namesMap.put("KW", "Күвејт");
    namesMap.put("KY", "Кајман адалары");
    namesMap.put("KZ", "Газахыстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент-Лусија");
    namesMap.put("LI", "Лихтенштејн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерија");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Лүксембург");
    namesMap.put("LV", "Латвија");
    namesMap.put("LY", "Ливија");
    namesMap.put("MA", "Мәракеш");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Монтенегро");
    namesMap.put("MF", "Сент Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршал адалары");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мјанма");
    namesMap.put("MN", "Монголустан");
    namesMap.put("MO", "Макао Хүсуси Инзибати Әрази Чин");
    namesMap.put("MP", "Шимали Мариан адалары");
    namesMap.put("MQ", "Мартиник");
    namesMap.put("MR", "Мавританија");
    namesMap.put("MS", "Монсерат");
    namesMap.put("MT", "Малта");
    namesMap.put("MU", "Маврики");
    namesMap.put("MV", "Малдив адалары");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малајзија");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибија");
    namesMap.put("NC", "Јени Каледонија");
    namesMap.put("NE", "Ниҝер");
    namesMap.put("NF", "Норфолк адасы");
    namesMap.put("NG", "Ниҝерија");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерланд");
    namesMap.put("NO", "Норвеч");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Јени Зеландија");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Франса Полинезијасы");
    namesMap.put("PG", "Папуа-Јени Гвинеја");
    namesMap.put("PH", "Филиппин");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Полша");
    namesMap.put("PM", "Мүгәддәс Пјер вә Микелон");
    namesMap.put("PN", "Питкерн адалары");
    namesMap.put("PR", "Пуерто Рико");
    namesMap.put("PT", "Португалија");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвај");
    namesMap.put("QA", "Гәтәр");
    namesMap.put("QO", "Узаг Океанија");
    namesMap.put("RE", "Рејунјон");
    namesMap.put("RO", "Румынија");
    namesMap.put("RS", "Сербија");
    namesMap.put("RU", "Русија");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Сәудијјә Әрәбистаны");
    namesMap.put("SB", "Соломон адалары");
    namesMap.put("SC", "Сејшел адалары");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Исвеч");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Мүгәддәс Јелена");
    namesMap.put("SI", "Словенија");
    namesMap.put("SJ", "Свалбард вә Јан-Мајен");
    namesMap.put("SK", "Словакија");
    namesMap.put("SL", "Сјерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Ҹәнуби Судан");
    namesMap.put("ST", "Сан-Томе вә Принсипи");
    namesMap.put("SV", "Салвадор");
    namesMap.put("SX", "Синт-Мартен");
    namesMap.put("SY", "Сурија");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан да Кунја");
    namesMap.put("TC", "Төркс вә Кајкос адалары");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Франсанын Ҹәнуб Әразиләри");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Таиланд");
    namesMap.put("TJ", "Таҹикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Шәрги Тимор");
    namesMap.put("TM", "Түркмәнистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Түркијә");
    namesMap.put("TT", "Тринидад вә Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тајван");
    namesMap.put("TZ", "Танзанија");
    namesMap.put("UA", "Украјна");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АБШ-а бағлы кичик адаҹыглар");
    namesMap.put("US", "Америка Бирләшмиш Штатлары");
    namesMap.put("UY", "Уругвај");
    namesMap.put("UZ", "Өзбәкистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Винсент вә Гренадинләр");
    namesMap.put("VE", "Венесуела");
    namesMap.put("VG", "Британијанын Вирҝин адалары");
    namesMap.put("VI", "АБШ Вирҝин адалары");
    namesMap.put("VN", "Вјетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис вә Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Јәмән");
    namesMap.put("YT", "Мајот");
    namesMap.put("ZA", "Ҹәнуб Африка");
    namesMap.put("ZM", "Замбија");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Намәлум Реҝион");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Дүнја",
        "002": "Африка",
        "003": "Шимали Америка",
        "005": "Ҹәнуби Америка",
        "009": "Океанија",
        "011": "Гәрби Африка",
        "013": "Мәркәзи Америка",
        "014": "Шәрги Африка",
        "015": "Шимали Африка",
        "017": "Мәркәзи Африка",
        "018": "Ҹәнуби Африка",
        "019": "Америка",
        "021": "Шимал Америкасы",
        "029": "Кариб",
        "030": "Шәрги Асија",
        "034": "Ҹәнуби Асија",
        "035": "Ҹәнуб-Шәрги Асија",
        "039": "Ҹәнуби Авропа",
        "053": "Австралазија",
        "054": "Меланезија",
        "057": "Микронезија Реҝиону",
        "061": "Полинезија",
        "142": "Асија",
        "143": "Мәркәзи Асија",
        "145": "Гәрби Асија",
        "150": "Авропа",
        "151": "Шәрги Авропа",
        "154": "Шимали Авропа",
        "155": "Гәрби Авропа",
        "419": "Латын Америкасы",
        "AC": "Аскенсон адасы",
        "AD": "Андорра",
        "AE": "Бирләшмиш Әрәб Әмирликләри",
        "AF": "Әфганыстан",
        "AG": "Антигуа вә Барбуда",
        "AI": "Анҝилја",
        "AL": "Албанија",
        "AM": "Ермәнистан",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Арҝентина",
        "AS": "Америка Самоасы",
        "AT": "Австрија",
        "AU": "Австралија",
        "AW": "Аруба",
        "AX": "Аланд адалары",
        "AZ": "Азәрбајҹан",
        "BA": "Боснија вә Һерсеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белчика",
        "BF": "Буркина Фасо",
        "BG": "Болгарыстан",
        "BH": "Бәһрејн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сент-Бартелеми",
        "BM": "Бермуд адалары",
        "BN": "Брунеј",
        "BO": "Боливија",
        "BR": "Бразилија",
        "BS": "Баһам адалары",
        "BT": "Бутан",
        "BV": "Буве адасы",
        "BW": "Ботсвана",
        "BY": "Беларус",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокос (Килинг) адалары",
        "CD": "Конго-Киншаса",
        "CF": "Мәркәзи Африка Республикасы",
        "CG": "Конго-Браззавил",
        "CH": "Исвечрә",
        "CI": "Kотд’ивуар",
        "CK": "Кук адалары",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Чин",
        "CO": "Колумбија",
        "CP": "Клиппертон адасы",
        "CR": "Коста Рика",
        "CU": "Куба",
        "CV": "Кабо-Верде",
        "CW": "Курасао",
        "CX": "Милад адасы",
        "CY": "Кипр",
        "CZ": "Чехија",
        "DE": "Алманија",
        "DG": "Диего Гарсија",
        "DJ": "Ҹибути",
        "DK": "Данимарка",
        "DM": "Доминика",
        "DO": "Доминикан Республикасы",
        "DZ": "Әлҹәзаир",
        "EA": "Сеута вә Мелилја",
        "EC": "Еквадор",
        "EE": "Естонија",
        "EG": "Мисир",
        "ER": "Еритреја",
        "ES": "Испанија",
        "ET": "Ефиопија",
        "EU": "Авропа Бирлији",
        "FI": "Финландија",
        "FJ": "Фиҹи",
        "FK": "Фолкленд адалары",
        "FM": "Микронезија",
        "FO": "Фарер адалары",
        "FR": "Франса",
        "GA": "Габон",
        "GB": "Бирләшмиш Краллыг",
        "GD": "Гренада",
        "GE": "Ҝүрҹүстан",
        "GF": "Франса Гвианасы",
        "GG": "Ҝернси",
        "GH": "Гана",
        "GI": "Ҹәбәллүтариг",
        "GL": "Гренландија",
        "GM": "Гамбија",
        "GN": "Гвинеја",
        "GP": "Гваделупа",
        "GQ": "Екваториал Гвинеја",
        "GR": "Јунаныстан",
        "GS": "Ҹәнуби Ҹорҹија вә Ҹәнуби Сендвич адалары",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинеја-Бисау",
        "GY": "Гајана",
        "HK": "Һонк Конг Хүсуси Инзибати Әрази Чин",
        "HM": "Һерд вә Макдоналд адалары",
        "HN": "Һондурас",
        "HR": "Хорватија",
        "HT": "Һаити",
        "HU": "Маҹарыстан",
        "IC": "Канар адалары",
        "ID": "Индонезија",
        "IE": "Ирландија",
        "IL": "Исраил",
        "IM": "Мен адасы",
        "IN": "Һиндистан",
        "IO": "Британтјанын Һинд Океаны Әразиси",
        "IQ": "Ираг",
        "IR": "Иран",
        "IS": "Исландија",
        "IT": "Италија",
        "JE": "Ҹерси",
        "JM": "Јамајка",
        "JO": "Иорданија",
        "JP": "Јапонија",
        "KE": "Кенија",
        "KG": "Гырғызыстан",
        "KH": "Камбоҹа",
        "KI": "Кирибати",
        "KM": "Комор адалары",
        "KN": "Сент-Китс вә Невис",
        "KP": "Шимали Кореја",
        "KR": "Ҹәнуби Кореја",
        "KW": "Күвејт",
        "KY": "Кајман адалары",
        "KZ": "Газахыстан",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Сент-Лусија",
        "LI": "Лихтенштејн",
        "LK": "Шри-Ланка",
        "LR": "Либерија",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Лүксембург",
        "LV": "Латвија",
        "LY": "Ливија",
        "MA": "Мәракеш",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Монтенегро",
        "MF": "Сент Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршал адалары",
        "ML": "Мали",
        "MM": "Мјанма",
        "MN": "Монголустан",
        "MO": "Макао Хүсуси Инзибати Әрази Чин",
        "MP": "Шимали Мариан адалары",
        "MQ": "Мартиник",
        "MR": "Мавританија",
        "MS": "Монсерат",
        "MT": "Малта",
        "MU": "Маврики",
        "MV": "Малдив адалары",
        "MW": "Малави",
        "MX": "Мексика",
        "MY": "Малајзија",
        "MZ": "Мозамбик",
        "NA": "Намибија",
        "NC": "Јени Каледонија",
        "NE": "Ниҝер",
        "NF": "Норфолк адасы",
        "NG": "Ниҝерија",
        "NI": "Никарагуа",
        "NL": "Нидерланд",
        "NO": "Норвеч",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Јени Зеландија",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Франса Полинезијасы",
        "PG": "Папуа-Јени Гвинеја",
        "PH": "Филиппин",
        "PK": "Пакистан",
        "PL": "Полша",
        "PM": "Мүгәддәс Пјер вә Микелон",
        "PN": "Питкерн адалары",
        "PR": "Пуерто Рико",
        "PT": "Португалија",
        "PW": "Палау",
        "PY": "Парагвај",
        "QA": "Гәтәр",
        "QO": "Узаг Океанија",
        "RE": "Рејунјон",
        "RO": "Румынија",
        "RS": "Сербија",
        "RU": "Русија",
        "RW": "Руанда",
        "SA": "Сәудијјә Әрәбистаны",
        "SB": "Соломон адалары",
        "SC": "Сејшел адалары",
        "SD": "Судан",
        "SE": "Исвеч",
        "SG": "Сингапур",
        "SH": "Мүгәддәс Јелена",
        "SI": "Словенија",
        "SJ": "Свалбард вә Јан-Мајен",
        "SK": "Словакија",
        "SL": "Сјерра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринам",
        "SS": "Ҹәнуби Судан",
        "ST": "Сан-Томе вә Принсипи",
        "SV": "Салвадор",
        "SX": "Синт-Мартен",
        "SY": "Сурија",
        "SZ": "Свазиленд",
        "TA": "Тристан да Кунја",
        "TC": "Төркс вә Кајкос адалары",
        "TD": "Чад",
        "TF": "Франсанын Ҹәнуб Әразиләри",
        "TG": "Того",
        "TH": "Таиланд",
        "TJ": "Таҹикистан",
        "TK": "Токелау",
        "TL": "Шәрги Тимор",
        "TM": "Түркмәнистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Түркијә",
        "TT": "Тринидад вә Тобаго",
        "TV": "Тувалу",
        "TW": "Тајван",
        "TZ": "Танзанија",
        "UA": "Украјна",
        "UG": "Уганда",
        "UM": "АБШ-а бағлы кичик адаҹыглар",
        "US": "Америка Бирләшмиш Штатлары",
        "UY": "Уругвај",
        "UZ": "Өзбәкистан",
        "VA": "Ватикан",
        "VC": "Сент-Винсент вә Гренадинләр",
        "VE": "Венесуела",
        "VG": "Британијанын Вирҝин адалары",
        "VI": "АБШ Вирҝин адалары",
        "VN": "Вјетнам",
        "VU": "Вануату",
        "WF": "Уоллис вә Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Јәмән",
        "YT": "Мајот",
        "ZA": "Ҹәнуб Африка",
        "ZM": "Замбија",
        "ZW": "Зимбабве",
        "ZZ": "Намәлум Реҝион"
    };
  }-*/;
}
