/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.CustomFieldSerializer;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.server.Base64Utils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.CharVector;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ServerSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private static final Map<Class<?>, ValueWriter> CLASS_TO_VALUE_WRITER = new IdentityHashMap();
    private static final Map<Class<?>, VectorWriter> CLASS_TO_VECTOR_WRITER = new IdentityHashMap();
    private static final int NUMBER_OF_JS_ESCAPED_CHARS = 128;
    private static final char[] JS_CHARS_ESCAPED = new char[128];
    private static final char JS_ESCAPE_CHAR = '\\';
    private static final char JS_QUOTE_CHAR = '\"';
    private static final char[] NIBBLE_TO_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char NON_BREAKING_HYPHEN = '\u2011';
    private static final int MAX_STRING_NODE_LENGTH = 65535;
    private final SerializationPolicy serializationPolicy;
    private final TokenEncoder encoder;

    public static String escapeString(String toEscape) {
        return ServerSerializationStreamWriter.escapeString(toEscape, false);
    }

    public static String escapeStringSplitNodes(String toEscape) {
        return ServerSerializationStreamWriter.escapeString(toEscape, true);
    }

    private static String escapeString(String toEscape, boolean splitNodes) {
        int length = toEscape.length();
        int capacityIncrement = Math.max(length, 16);
        CharVector charVector = new CharVector(capacityIncrement * 2, capacityIncrement);
        charVector.add('\"');
        int i = 0;
        while (i < length) {
            int maxSegmentVectorSize;
            int n = maxSegmentVectorSize = splitNodes ? charVector.getSize() + 65535 - 5 : Integer.MAX_VALUE;
            while (i < length && charVector.getSize() < maxSegmentVectorSize) {
                char c;
                if (ServerSerializationStreamWriter.needsUnicodeEscape(c = toEscape.charAt(i++))) {
                    ServerSerializationStreamWriter.unicodeEscape(c, charVector);
                    continue;
                }
                charVector.add(c);
            }
            if (!splitNodes || i >= length) continue;
            charVector.add('\"');
            charVector.add('+');
            charVector.add('\"');
        }
        charVector.add('\"');
        return String.valueOf(charVector.asArray(), 0, charVector.getSize());
    }

    private static Class<?> getClassForSerialization(Object instance) {
        assert (instance != null);
        if (instance instanceof Enum) {
            Enum e = (Enum)instance;
            return e.getDeclaringClass();
        }
        return instance.getClass();
    }

    private static boolean needsUnicodeEscape(char ch) {
        switch (ch) {
            case ' ': {
                return false;
            }
            case '\"': 
            case '\\': {
                return true;
            }
            case '\u2011': {
                return true;
            }
            case '&': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': {
                return true;
            }
        }
        if (ch < ' ') {
            return true;
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static void unicodeEscape(char ch, CharVector charVector) {
        charVector.add('\\');
        if (ch < '\u0080' && JS_CHARS_ESCAPED[ch] != '\u0000') {
            charVector.add(JS_CHARS_ESCAPED[ch]);
        } else {
            charVector.add('u');
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 12 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 8 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 4 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch & 0xF]);
        }
    }

    public ServerSerializationStreamWriter(SerializationPolicy serializationPolicy, int version, Writer writer) {
        this.setVersion(version);
        this.serializationPolicy = serializationPolicy;
        this.encoder = new TokenEncoder(version, writer);
    }

    @Override
    public void prepareToWrite() {
        super.prepareToWrite();
    }

    public void serializeValue(Object value, Class<?> type) throws SerializationException {
        ValueWriter valueWriter = CLASS_TO_VALUE_WRITER.get(type);
        if (valueWriter != null) {
            valueWriter.write(this, value);
        } else {
            ValueWriter.OBJECT.write(this, value);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " for serialization policy " + this.serializationPolicy;
    }

    public void writeStringTableAndHeaderAfterPayloadFinished() throws IOException {
        this.encoder.finishPayload();
        this.writeStringTable();
        this.writeHeader();
        this.encoder.finish();
    }

    @Override
    public void writeLong(long value) {
        if (this.getVersion() == 5) {
            double[] parts = ServerSerializationStreamWriter.getAsDoubleArray(value);
            assert (parts != null && parts.length == 2);
            this.writeDouble(parts[0]);
            this.writeDouble(parts[1]);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(Base64Utils.toBase64(value));
            sb.append('\"');
            this.append(sb.toString());
        }
    }

    @Override
    public void writeDouble(double fieldValue) {
        if (this.getVersion() >= 8 && (Double.isNaN(fieldValue) || Double.isInfinite(fieldValue))) {
            this.append('\"' + String.valueOf(fieldValue) + '\"');
        } else {
            super.writeDouble(fieldValue);
        }
    }

    @Override
    protected void append(String token) {
        this.encoder.addPayloadToken(token);
    }

    @Override
    protected String getObjectTypeSignature(Object instance) throws SerializationException {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        if (this.hasFlags(1)) {
            if (this.serializationPolicy instanceof TypeNameObfuscator) {
                return ((TypeNameObfuscator)((Object)this.serializationPolicy)).getTypeIdForClass(clazz);
            }
            throw new SerializationException("The GWT module was compiled with RPC type name elision enabled, but " + this.serializationPolicy.getClass().getName() + " does not implement " + TypeNameObfuscator.class.getName());
        }
        return SerializabilityUtil.encodeSerializedInstanceReference(clazz, this.serializationPolicy);
    }

    @Override
    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        try {
            this.serializationPolicy.validateSerialize(clazz);
        }
        catch (SerializationException e) {
            throw new SerializationException(e.getMessage() + ": instance = " + instance);
        }
        this.serializeImpl(instance, clazz);
    }

    private void serializeArray(Class<?> instanceClass, Object instance) throws SerializationException {
        assert (instanceClass.isArray());
        VectorWriter instanceWriter = CLASS_TO_VECTOR_WRITER.get(instanceClass);
        if (instanceWriter != null) {
            instanceWriter.write(this, instance);
        } else {
            VectorWriter.OBJECT_VECTOR.write(this, instance);
        }
    }

    private void serializeClass(Object instance, Class<?> instanceClass) throws SerializationException {
        assert (instance != null);
        Field[] serializableFields = SerializabilityUtil.applyFieldSerializationPolicy(instanceClass, this.serializationPolicy);
        Set<String> clientFieldNames = this.serializationPolicy.getClientFieldNamesForEnhancedClass(instanceClass);
        if (clientFieldNames != null) {
            ArrayList serverFields = new ArrayList();
            for (Field declField : serializableFields) {
                assert (declField != null);
                if (clientFieldNames.contains(declField.getName())) continue;
                serverFields.add(declField);
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(serverFields.size());
                Iterator iterator = serverFields.iterator();
                while (iterator.hasNext()) {
                    Field f = (Field)iterator.next();
                    oos.writeObject(f.getName());
                    f.setAccessible(true);
                    Object fieldData = f.get(instance);
                    oos.writeObject(fieldData);
                }
                oos.close();
                byte[] serializedData = baos.toByteArray();
                String encodedData = Base64Utils.toBase64(serializedData);
                this.writeString(encodedData);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
        for (Field declField : serializableFields) {
            boolean needsAccessOverride;
            if (clientFieldNames != null && !clientFieldNames.contains(declField.getName())) continue;
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            try {
                Object value = declField.get(instance);
                this.serializeValue(value, declField.getType());
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
        }
        Class<?> superClass = instanceClass.getSuperclass();
        if (this.serializationPolicy.shouldSerializeFields(superClass)) {
            this.serializeImpl(instance, superClass);
        }
    }

    private void serializeImpl(Object instance, Class<?> instanceClass) throws SerializationException {
        assert (instance != null);
        Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceClass);
        if (customSerializer != null) {
            CustomFieldSerializer<?> customFieldSerializer = SerializabilityUtil.loadCustomFieldSerializer(customSerializer);
            if (customFieldSerializer == null) {
                this.serializeWithCustomSerializer(customSerializer, instance, instanceClass);
            } else {
                customFieldSerializer.serializeInstance(this, instance);
            }
        } else if (instanceClass.isArray()) {
            this.serializeArray(instanceClass, instance);
        } else if (instanceClass.isEnum()) {
            this.writeInt(((Enum)instance).ordinal());
        } else {
            this.serializeClass(instance, instanceClass);
        }
    }

    private void serializeWithCustomSerializer(Class<?> customSerializer, Object instance, Class<?> instanceClass) throws SerializationException {
        try {
            assert (!instanceClass.isArray());
            for (Method method : customSerializer.getMethods()) {
                if (!"serialize".equals(method.getName())) continue;
                method.invoke(null, this, instance);
                return;
            }
            throw new NoSuchMethodException("serialize");
        }
        catch (SecurityException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    private void writeHeader() throws IOException {
        this.encoder.addToken(this.getFlags());
        this.encoder.addToken(this.getVersion());
    }

    private void writeStringTable() throws IOException {
        StringWriter buffer = new StringWriter();
        TokenEncoder tableStream = new TokenEncoder(this.getVersion(), buffer);
        for (String s : this.getStringTable()) {
            tableStream.addEscapedToken(s);
        }
        tableStream.finish();
        this.encoder.addToken(buffer.toString());
    }

    static {
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[8] = 98;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[9] = 116;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[10] = 110;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[12] = 102;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[13] = 114;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[92] = 92;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[34] = 34;
        CLASS_TO_VECTOR_WRITER.put(boolean[].class, VectorWriter.BOOLEAN_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(byte[].class, VectorWriter.BYTE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(char[].class, VectorWriter.CHAR_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(double[].class, VectorWriter.DOUBLE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(float[].class, VectorWriter.FLOAT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(int[].class, VectorWriter.INT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(long[].class, VectorWriter.LONG_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(Object[].class, VectorWriter.OBJECT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(short[].class, VectorWriter.SHORT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(String[].class, VectorWriter.STRING_VECTOR);
        CLASS_TO_VALUE_WRITER.put(Boolean.TYPE, ValueWriter.BOOLEAN);
        CLASS_TO_VALUE_WRITER.put(Byte.TYPE, ValueWriter.BYTE);
        CLASS_TO_VALUE_WRITER.put(Character.TYPE, ValueWriter.CHAR);
        CLASS_TO_VALUE_WRITER.put(Double.TYPE, ValueWriter.DOUBLE);
        CLASS_TO_VALUE_WRITER.put(Float.TYPE, ValueWriter.FLOAT);
        CLASS_TO_VALUE_WRITER.put(Integer.TYPE, ValueWriter.INT);
        CLASS_TO_VALUE_WRITER.put(Long.TYPE, ValueWriter.LONG);
        CLASS_TO_VALUE_WRITER.put(Object.class, ValueWriter.OBJECT);
        CLASS_TO_VALUE_WRITER.put(Short.TYPE, ValueWriter.SHORT);
        CLASS_TO_VALUE_WRITER.put(String.class, ValueWriter.STRING);
    }

    private static enum VectorWriter {
        BOOLEAN_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                boolean[] vector = (boolean[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeBoolean(vector[i]);
                }
            }
        }
        ,
        BYTE_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                byte[] vector = (byte[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeByte(vector[i]);
                }
            }
        }
        ,
        CHAR_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                char[] vector = (char[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeChar(vector[i]);
                }
            }
        }
        ,
        DOUBLE_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                double[] vector = (double[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeDouble(vector[i]);
                }
            }
        }
        ,
        FLOAT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                float[] vector = (float[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeFloat(vector[i]);
                }
            }
        }
        ,
        INT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                int[] vector = (int[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeInt(vector[i]);
                }
            }
        }
        ,
        LONG_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                long[] vector = (long[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeLong(vector[i]);
                }
            }
        }
        ,
        OBJECT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                Object[] vector = (Object[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeObject(vector[i]);
                }
            }
        }
        ,
        SHORT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                short[] vector = (short[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeShort(vector[i]);
                }
            }
        }
        ,
        STRING_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                String[] vector = (String[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeString(vector[i]);
                }
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    private static enum ValueWriter {
        BOOLEAN{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeBoolean((Boolean)instance);
            }
        }
        ,
        BYTE{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeByte((Byte)instance);
            }
        }
        ,
        CHAR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeChar(((Character)instance).charValue());
            }
        }
        ,
        DOUBLE{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeDouble((Double)instance);
            }
        }
        ,
        FLOAT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeFloat(((Float)instance).floatValue());
            }
        }
        ,
        INT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeInt((Integer)instance);
            }
        }
        ,
        LONG{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeLong((Long)instance);
            }
        }
        ,
        OBJECT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                stream.writeObject(instance);
            }
        }
        ,
        SHORT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeShort((Short)instance);
            }
        }
        ,
        STRING{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeString((String)instance);
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    private static class TokenEncoder {
        private final Writer writer;
        private final List<CharSequence> tokensInReverseOrder;
        private boolean needsComma = false;

        public TokenEncoder(int version, Writer writer) {
            this.writer = writer;
            this.tokensInReverseOrder = version < 9 ? new LinkedList<CharSequence>() : null;
            try {
                writer.append("[");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void addPayloadToken(CharSequence token) {
            if (this.tokensInReverseOrder == null) {
                this.addTokenToWriter(token);
            } else {
                this.tokensInReverseOrder.add(0, token);
            }
        }

        public void addToken(CharSequence token) {
            this.addTokenToWriter(token);
        }

        private void addTokenToWriter(CharSequence token) {
            try {
                if (this.needsComma) {
                    this.writer.append(",");
                } else {
                    this.needsComma = true;
                }
                this.writer.append(token);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void addEscapedToken(String token) {
            this.addToken(ServerSerializationStreamWriter.escapeString(token, false));
        }

        public void addToken(int i) {
            this.addToken(String.valueOf(i));
        }

        public void finishPayload() {
            if (this.tokensInReverseOrder != null) {
                for (CharSequence payloadToken : this.tokensInReverseOrder) {
                    this.addTokenToWriter(payloadToken);
                }
            }
        }

        public void finish() {
            try {
                this.writer.append("]");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [writer=" + this.writer + ", needsComma=" + this.needsComma + "]";
        }
    }
}

